/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class LivingBuildingModule
extends AbstractBuildingModule
implements IAssignsCitizen,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void deserializeNBT(CompoundNBT compound) {
        if (compound.func_150296_c().contains("residents")) {
            int[] residentIds;
            for (int citizenId : residentIds = compound.func_74759_k("residents")) {
                ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        if (this.building.hasAssignedCitizen()) {
            int[] residentIds = new int[this.building.getAssignedCitizen().size()];
            for (int i = 0; i < this.building.getAssignedCitizen().size(); ++i) {
                residentIds[i] = this.building.getAssignedCitizen().get(i).getId();
            }
            compound.func_74783_a("residents", residentIds);
        }
    }

    @Override
    public void onDestroyed() {
        this.building.getAssignedCitizen().stream().filter(Objects::nonNull).forEach(citizen -> citizen.setHomeBuilding(null));
    }

    @Override
    public boolean removeCitizen(@NotNull ICitizenData citizen) {
        if (this.building.isCitizenAssigned(citizen)) {
            ((AbstractCitizenAssignable)this.building).removeAssignedCitizen(citizen);
            this.building.getColony().getCitizenManager().calculateMaxCitizens();
            this.markDirty();
            citizen.setHomeBuilding(null);
            return true;
        }
        return false;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.building.isFull() && !this.building.getColony().isManualHousing()) {
            this.addHomelessCitizens();
        }
    }

    private void addHomelessCitizens() {
        for (ICitizenData citizen : this.building.getColony().getCitizenManager().getCitizens()) {
            if (this.building.isFull()) break;
            this.moveCitizenToHut(citizen);
        }
    }

    private void moveCitizenToHut(ICitizenData citizen) {
        if (citizen.getHomeBuilding() instanceof LivingBuildingModule && citizen.getHomeBuilding().getBuildingLevel() < this.building.getBuildingLevel()) {
            citizen.getHomeBuilding().removeCitizen(citizen);
        }
        if (citizen.getHomeBuilding() == null) {
            this.assignCitizen(citizen);
        }
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getHomeBuilding() != null) {
            citizen.getHomeBuilding().removeCitizen(citizen);
        }
        if (!this.buildingAssignmentLogic(citizen)) {
            return false;
        }
        citizen.setHomeBuilding(this.building);
        return true;
    }

    @Override
    public int getModuleMax() {
        return this.building.getMaxInhabitants();
    }

    private boolean buildingAssignmentLogic(ICitizenData citizen) {
        if (this.building.getAssignedCitizen().contains(citizen) || this.building.isFull()) {
            return false;
        }
        if (citizen != null) {
            ((AbstractCitizenAssignable)this.building).addAssignedCitizen(citizen);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
        this.markDirty();
        return true;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.building.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeInt(this.building.getAssignedCitizen().size());
        for (ICitizenData citizen : this.building.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
        List<ICitizenData> residents = oldBuilding.getAssignedCitizen();
        for (ICitizenData citizen : residents) {
            citizen.setHomeBuilding(this.building);
            this.assignCitizen(citizen);
        }
    }
}

